#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "ctrl/BOLTPictures.h"

//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brPreview.h"
#include "report/brReport.h"
#include "wx/statline.h"
enum {
 ID_NEW=13040,
 ID_EDIT,
 ID_DELETE,
 ID_UP,
 ID_DOWN,
 ID_ITEM,
 ID_IMAGE,
 ID_IMAGEON,
 ID_SCALEON,
 ID_LABEL

};

//IMPLEMENT_DYNAMIC_CLASS(brReport,wxPanel)
BEGIN_EVENT_TABLE(brReport,wxPanel)
EVT_BUTTON(ID_IMAGE,brReport::OnChooseImage)
EVT_TEXT(ID_ITEM,brReport::OnText)
EVT_TEXT(ID_LABEL,brReport::OnText)
EVT_CHECKBOX(ID_IMAGEON,brReport::OnImageCheck)
EVT_CHECKBOX(ID_SCALEON,brReport::OnScaleCheck)
END_EVENT_TABLE()

brReport::brReport(wxWindow *parent,BOLTdb *db, 
				   RECORD_ID recordId,brPreview *preview):
 wxPanel(parent,-1)
{
created=false;
SetBackgroundColour(parent->GetBackgroundColour());
this->db=db;
	SetFont(parent->GetFont());
this->recordId=recordId;
this->preview=preview;
if  (!db->GetValue("reportLayouts","id",recordId))
{ db->NewRecord("reportLayouts",recordId); }

wxBoxSizer *topSizer,*hSizer;
//wxStaticBoxSizer *sbSizer;

topSizer=new wxBoxSizer(wxVERTICAL);
topSizer->Add(new wxStaticText(this,-1,"Layout"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);

hSizer=new wxBoxSizer(wxHORIZONTAL);
hSizer->Add(new wxStaticText(this,-1,"Report Name"),0,wxALL|7);
hSizer->Add(new bcItem(this,ID_LABEL,"reports","name",db,recordId),1,wxEXPAND|wxALL,5);
topSizer->Add(hSizer,0,wxEXPAND);

//hSizer=new wxBoxSizer(wxVERTICAL);
wxGridSizer *gSizer;
gSizer=new wxGridSizer(3,2,2);
//sbSizer=new wxStaticBoxSizer(new wxStaticBox(this,-1,"Page Size"),wxHORIZONTAL);
//vSizer=new wxBoxSizer(wxHORIZONTAL);
gSizer->Add(1,1,1);
gSizer->Add(new wxStaticText(this,-1,"Horizontal"),1);
gSizer->Add(new wxStaticText(this,-1,"Vertical"),1);
//gSizer->Add(vSizer,1,wxEXPAND);
//vSizer=new wxBoxSizer(wxHORIZONTAL);
gSizer->Add(new wxStaticText(this,-1,"Page Size"),1,wxALL,2);
gSizer->Add(new bcItem(this,ID_ITEM,"reportLayouts","width",db,this->recordId),1);
gSizer->Add(new bcItem(this,ID_ITEM,"reportLayouts","height",db,this->recordId),1);
//hSizer->Add(vSizer,0);
//vSizer=new wxBoxSizer(wxHORIZONTAL);
gSizer->Add(new wxStaticText(this,-1,"Upper Margin"),1,wxALL,2);
gSizer->Add(new bcItem(this,ID_ITEM,"reportLayouts","mLeft",db,this->recordId),1);
gSizer->Add(new bcItem(this,ID_ITEM,"reportLayouts","mRight",db,this->recordId),1);
//hSizer->Add(vSizer,0);
//gSizer=new wxBoxSizer(wxHORIZONTAL);
gSizer->Add(new wxStaticText(this,-1,"Lower Margin"),1,wxALL,2);
gSizer->Add(new bcItem(this,ID_ITEM,"reportLayouts","mTop",db,this->recordId),1);
gSizer->Add(new bcItem(this,ID_ITEM,"reportLayouts","mBottom",db,this->recordId),1);
//hSizer->Add(vSizer,0);

gSizer->Add(new wxCheckBox(this,ID_IMAGEON,"Use Image"),0,wxALL,2);
gSizer->Add(new wxButton(this,ID_IMAGE,"Choose Image"),0);
gSizer->Add(new wxCheckBox(this,ID_SCALEON,"Scale to fit"),0,wxALL,2);

topSizer->Add(gSizer,0,wxEXPAND);

((wxCheckBox *)this->FindWindow(ID_IMAGEON))->SetValue(db->GetValue("reportLayouts","useImage",recordId)!=NULL);
((wxCheckBox *)this->FindWindow(ID_SCALEON))->SetValue(db->GetValue("reportLayouts","imageScale",recordId)!=NULL);
//topSizer->Add(hSizer,1,wxEXPAND);


SetSizerAndFit(topSizer);
created=true;
};


void brReport::OnText(wxCommandEvent &event)
{
	bcItem *item;
	item = (bcItem *)event.GetEventObject();
	if (item) { item->OnEdit();}
	if (item->GetId()!=ID_LABEL)
	{ if (created){	preview->Refresh();} }
}


//IMPLEMENT_DYNAMIC_CLASS(brReportEditor,wxDialog)
BEGIN_EVENT_TABLE(brReportEditor,wxDialog)
END_EVENT_TABLE()

brReportEditor::brReportEditor(wxWindow *parent,BOLTdb *db,RECORD_ID recordId) :
wxDialog(parent,-1,"brReport Editor",wxDefaultPosition)
{	 this->db=db;
	 this->recordId=recordId;
	SetFont(parent->GetFont());
};


void brReport::OnChooseImage(wxCommandEvent & event)
{
	wxString path;
	wxGetApp().frame->Enable(FALSE);
	path=wxFileSelector("Locate the background image :",
		"","","Jpeg Images|*.jpg","*.*",0,this);
	wxGetApp().frame->Enable(TRUE);
	if (!path.IsEmpty())
	{
		bcPicture *picture;
		db->NewRecord("reportPictures",recordId);
		picture=new bcPicture(db,"reportPictures",recordId,recordId);
		picture->LoadFile(path);
		picture->SaveToDatabase();
	}
	this->preview->Refresh();
}

void brReport::OnImageCheck(wxCommandEvent &event)
{
	db->SetValue("reportLayouts","useImage",recordId,"if(useImage is not null,NULL,1)");
	this->preview->Refresh();
}

void brReport::OnScaleCheck(wxCommandEvent &event)
{
	db->SetValue("reportLayouts","imageScale",recordId,"if(imageScale is not null,NULL,1)");
	this->preview->Refresh();
}
